setwd("?????????????????????????")
landuse<-read.csv("Soilfractionsdata.csv")
head(landuse)

library(lattice)
library(nlme)
library(lme4)
library(lmerTest)


# PLEASE NOTE THAT I HAVE ALTERED THE LABEL OF THE REPLICATES
# THIS IMPLIES A NESTED DESIGN WITHIN THE DATA STRUCTURE
# AND WE CAN FIT A SIMPLE LME TO TEST FOR LANDUSE EFFECTS

# I HAVE ALSO REMOVED ZERO VALUES, AS SOME OF THE VARIABLES NEED TO BE LOG-TRANSFORMED


################ SOC
lmeA1<-lmer(log(SOC) ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeA2<-lmer(log(SOC) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeA3<-lmer(SOC ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeA4<-lmer(SOC ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
A1 <- lme(log(SOC)~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML") 
A2 <- lme(SOC~ Type+Depth, data =landuse,random = ~1|Replicate,method = "REML")
A3 <- lme(SOC~ Depth, data =landuse,random = ~1|Replicate,method = "REML") 
AIC(lmeA1,  lmeA2, lmeA3, lmeA4)
AIC(A1,A2,A3)
anova(A1)
#            numDF denDF   F-value p-value
#(Intercept)     1    53 1447.2798  <.0001
#Type            3    53  183.3155  <.0001
#Depth           1    53  135.8476  <.0001
#Type:Depth      3    53    6.1149  0.0012
# Test the models with the lowest AIC values to choose model with the best fit
# e.g. if models 1 and 2 have the lowest AIC values
anova(lmeA1, lmeA2) 

#null model and comparison of best fit model (lmeX) against the null model
lmeA0<-lmer(log(SOC) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeA1, lmeA0) 
anova(lmeA1)

#Analysis of Variance Table
#Df  Sum Sq Mean Sq  F value
#Type        3 30.5770 10.1923 183.3155
#Depth       1  7.5531  7.5531 135.8476
#Type:Depth  3  1.0200  0.3400   6.1149

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeA1)  ~ fitted(lmeA1))
abline(h=0, lty=2)
hist(resid(lmeA1))
qqnorm(resid(lmeA1))
qqline(resid(lmeA1))

########## C2000 

lmeB1<-lme(log(C2000) ~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeB2<-lmer(log(C2000) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeB3<-lmer(log(C2000) ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeB4<-lmer(log(C2000) ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeB1, lmeB2, lmeB3, lmeB4)

anova(lmeB1, lmeB2)
# Test the models with the lowest AIC values to choose model with the best fit
# e.g. if models 1 and 2 have the lowest AIC values
anova(lmeB1, lmeB2) 

#null model and comparison of best fit model (lmeX) against the null model
lmeB0<-lmer(log(C2000) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeB1, lmeB0) 
anova(lmeB1)
#Analysis of Variance Table
#Df Sum Sq Mean Sq F value
#Type        3 14.562   4.854  22.303
#Depth       1 42.694  42.694 196.165
#Type:Depth  3  7.519   2.506  11.515
summary(lmeB1)

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeB1)  ~ fitted(lmeB1))
abline(h=0, lty=2)
hist(resid(lmeB1))
qqnorm(resid(lmeB1))
qqline(resid(lmeB1))

########## C250 

lmeC1<-lme(log(C250) ~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeC2<-lmer(log(C250) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeC3<-lmer(log(C250) ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeC4<-lmer(log(C250) ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeC1, lmeC2, lmeC3, lmeC4)

anova(lmeC1, lmeC2) 
# Test the models with the lowest AIC values to choose model with the best fit
# e.g. if models 1 and 2 have the lowest AIC values
anova(lmeC1, lmeC2) 

#null model and comparison of best fit model (lmeX) against the null model
lmeC0<-lmer(log(C250) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeC1, lmeC0) 
anova(lmeC1)
#Analysis of Variance Table
#Df Sum Sq Mean Sq F value
#type        3 9.6787  3.2262 32.0556
#Depth       1 6.2738  6.2738 62.3358
#Type:Depth  3 0.9863  0.3288  3.2667 0.0294


#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeC1)  ~ fitted(lmeC1))
abline(h=0, lty=2)
hist(resid(lmeC1))
qqnorm(resid(lmeC1))
qqline(resid(lmeC1))

########## Cmicro

lmeD1<-lme(log(Cmicro)~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit)
lmeD2<-lmer(log(Cmicro) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeD3<-lmer(log(Cmicro) ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeD4<-lmer(log(Cmicro) ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeD1, lmeD2, lmeD3, lmeD4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g. if models 1 and 2 have the lowest AIC values
anova(lmeD1, lmeD2) 
# NO SIG effect from interaction, choose lmeD2
#null model and comparison of best fit model (lmeX) against the null model
lmeD0<-lmer(log(Cmicro) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeD2, lmeD0) 
anova(lmeD1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        3 11.2068  3.7356 59.6397
#Depth       1  0.5510  0.5510  8.7966
#Type:Depth  3  0.3153  0.1051  1.6777
#
anova(lmeD2)

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeD1)  ~ fitted(lmeD1))
abline(h=0, lty=2)
hist(resid(lmeD1))
qqnorm(resid(lmeD1))
qqline(resid(lmeD1))
########## Csc
lmeE1<-lme(log(Csc)~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit)
lmeE2<-lmer(log(Csc) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeE3<-lmer(log(Csc) ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeE4<-lmer(log(Csc) ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeE1, lmeE2, lmeE3, lmeE4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova(lmeE1, lmeE2) 
# NO SIG effect from interaction, choose lmeD2
#null model and comparison of best fit model (lmeX) against the null model
lmeE0<-lmer(log(Csc) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeE2, lmeE0) 
anova(lmeE1)
#Analysis of Variance Table
#Df Sum Sq Mean Sq F value
#Type        3 7.6847 2.56158 29.6979
#Depth       1 2.4579 2.45789 28.4958
#Type:Depth  3 0.5916 0.19721  2.2864
anova(lmeE2)

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeE1)  ~ fitted(lmeE1))
abline(h=0, lty=2)
hist(resid(lmeE1))
qqnorm(resid(lmeE1))
qqline(resid(lmeE1))
########## CLF
lmeF1<-lmer(CLF ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeF2<-lmer(CLF ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeF3<-lmer(CLF ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeF4<-lmer(CLF ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeF1, lmeF2, lmeF3, lmeF4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova(lmeF1, lmeF2) 
# NO SIG effect from interaction, choose lmeD2
#null model and comparison of best fit model (lmeX) against the null model
lmeF0<-lmer(CLF ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeF1, lmeF0) 
anova(lmeF1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        3 17.0139  5.6713 13.6318
#Depth       1 12.6655 12.6655 30.4432
#Type:Depth  3  1.5105  0.5035  1.2103
anova(lmeF2)

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeF1)  ~ fitted(lmeF1))
abline(h=0, lty=2)
hist(resid(lmeF1))
qqnorm(resid(lmeF1))
qqline(resid(lmeF1))
########## CHF
lmeG1<-lmer(log(CHF) ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeG2<-lmer(log(CHF) ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeG3<-lmer(log(CHF) ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeG4<-lmer(log(CHF) ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeG1, lmeG2, lmeG3, lmeG4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova( lmeG2,lmeG3,lmeG4) 
# NO SIG effect from interaction, choose lmeD2
#null model and comparison of best fit model (lmeX) against the null model
lmeG0<-lmer(log(CHF)~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeG1, lmeG0) 
anova(lmeG1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        3 6.4683  2.1561  49.3884
#Depth       1 8.5487  8.5487 195.8193
#Type:Depth  3 0.1110  0.0370   0.8476
anova(lmeG2)

#diagnostic plots of the final model fit

par(mfrow=c(2,2))

plot(resid(lmeG1)  ~ fitted(lmeG1))
abline(h=0, lty=2)
hist(resid(lmeG1))
qqnorm(resid(lmeG1))
qqline(resid(lmeG1))

########## fnew
lmeH1<-lmer(fnew ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeH2<-lmer(fnew  ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeH3<-lmer(fnew  ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeH4<-lmer(fnew  ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeH1, lmeH2, lmeH3, lmeH4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova( lmeH1,lmeH2,lmeH3,lmeH4) 
#choose model 1
#null model and comparison of best fit model (lmeX) against the null model
lmeH0<-lmer(fnew~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeH2, lmeH0) 
anova(lmeH2)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        2 0.058192 0.029096  8.4506
#Depth       1 0.119004 0.119004 34.222


#diagnostic plots of the final model fit

par(mfrow=c(2,2))
plot(resid(lmeH1)  ~ fitted(lmeH1))
abline(h=0, lty=2)
hist(resid(lmeH1))
qqnorm(resid(lmeH1))
qqline(resid(lmeH1))

########## fold
lmeI1<-lmer(fold ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeI2<-lmer(fold  ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeI3<-lmer(fold  ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeI4<-lmer(fold  ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeI1, lmeI2, lmeI3, lmeI4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova( lmeI1,lmeI3) 
#choose model 1
#null model and comparison of best fit model (lmeX) against the null model
lmeI0<-lmer(fnew~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeI1, lmeI0) 
anova(lmeI1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        2 0.058192 0.029096  8.4506
#Depth       1 0.119004 0.119004 34.5635
#Type:Depth  2 0.007258 0.003629  1.0541

#diagnostic plots of the final model fit

par(mfrow=c(2,2))
plot(resid(lmeI1)  ~ fitted(lmeI1))
abline(h=0, lty=2)
hist(resid(lmeI1))
qqnorm(resid(lmeI1))
qqline(resid(lmeI1))

########## Kdecomp
lmeJ1<-lmer(Kdecomp  ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeJ2<-lmer(Kdecomp  ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeJ3<-lmer(Kdecomp ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeJ4<-lmer(Kdecomp  ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
AIC(lmeJ1, lmeJ2, lmeJ3, lmeJ4)

# Test the models with the lowest AIC values to choose model with the best fit
# e.g.  models 2 have the lowest AIC values BUT no different between mode 1 and mode 2
anova( lmeJ1,lmeJ3) 
#choose model 1
#null model and comparison of best fit model (lmeX) against the null model
lmeJ0<-lmer(fnew~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeJ1, lmeJ0) 
anova(lmeJ1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        2 5.4113e-05 2.7057e-05  7.3405
#Depth       1 1.4357e-04 1.4357e-04 38.9505
#Type:Depth  2 2.2251e-05 1.1125e-05  3.0183

#diagnostic plots of the final model fit

par(mfrow=c(2,2))
plot(resid(lmeJ1)  ~ fitted(lmeJ1))
abline(h=0, lty=2)
hist(resid(lmeJ1))
qqnorm(resid(lmeJ1))
qqline(resid(lmeJ1))

#######################TN
lmeTN1<-lmer(TN ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeTN2<-lmer(TN ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeTN3<-lmer(TN~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeTN4<-lmer(TN~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
TN1 <- lme(log(TN)~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML") 
TN2 <- lme(log(TN)~ Type+Depth, data =landuse,random = ~1|Replicate,method = "REML")
TN3 <- lme(log(TN)~ Depth, data =landuse,random = ~1|Replicate,method = "REML") 
AIC(lmeTN1,  lmeTN2, lmeTN3, lmeTN4)
AIC(TN1,TN2,TN3)
anova(TN1)
#            numDF denDF   F-value p-value
#Type            3     9  118.6306  <.0001
#Depth           1    47  170.5122  <.0001
#Type:Depth      3    47   28.1824  <.0001
# Test the models with the lowest AIC values to choose model with the best fit
# e.g. if models 1 and 2 have the lowest AIC values
anova(TN1, TN2) 

#null model and comparison of best fit model (lmeX) against the null model
lmeTN0<-lmer(log(SOC) ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeTN1, lmeTN0) 


par(mfrow=c(2,2))

plot(resid(TN1)  ~ fitted(TN1))
abline(h=0, lty=2)
hist(resid(TN1))
qqnorm(resid(TN1))
qqline(resid(TN1))

######################BD
lmeBD1<-lmer(BD ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeBD2<-lmer(BD ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeBD3<-lmer(BD ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeBD4<-lmer(BD ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)

AIC(lmeBD1,  lmeBD2, lmeBD3, lmeBD4)

anova(lmeBD2,lmeBD4)

# Test the models with the lowest AIC values to choose model with the best fit

anova(lmeBD2)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type   3 0.16626 0.05542  9.4741
#Depth  1 0.40030 0.40030 68.4325
#null model and comparison of best fit model (lmeX) against the null model
lmeBD0<-lmer(BD ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeBD2, lmeTN0) 


par(mfrow=c(2,2))

plot(resid(lmeBD2)  ~ fitted(lmeBD2))
abline(h=0, lty=2)
hist(resid(lmeBD2))
qqnorm(resid(BD2))
qqline(resid(BD1))

######################CNratio
lmeCN1<-lmer(CN ~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeCN2<-lmer(CN ~ Type+Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeCN3<-lmer(CN ~ Type + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeCN4<-lmer(CN ~ Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)

AIC(lmeCN1,  lmeCN2, lmeCN3, lmeCN4)

anova(lmeCN1,lmeCN3)

# Test the models with the lowest AIC values to choose model with the best fit

anova(lmeCN1)
#Analysis of Variance Table
#Df  Sum Sq Mean Sq F value
#Type        3 44.331 14.7770 15.4765
#Depth       1  2.306  2.3063  2.4155
#Type:Depth  3  9.661  3.2203  3.3727
summary(lmeCN1)
#null model and comparison of best fit model (lmeX) against the null model
lmeCN0<-lmer(CN~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)

anova(lmeCN2, lmeTN0) 


par(mfrow=c(2,2))

plot(resid(lmeBD2)  ~ fitted(lmeBD2))
abline(h=0, lty=2)
hist(resid(lmeBD2))
qqnorm(resid(BD2))
qqline(resid(BD1))

####C13in litter
lmelitter1 <- lme(C13litter~ Type, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 

anova(lmelitter1)

####C13in LF
lmeLF1 <- lmer(C13LF~ Type*Depth + (1|Replicate), data = landuse, REML=T,na.action=na.omit)
lmeLF2 <- lme(C13LF~ Type+Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeLF3 <- lme(C13LF~ Type, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit)
lmeLF4 <- lme(C13LF~ Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
AIC(lmeLF1,lmeLF2,lmeLF3,lmeLF4)
anova(lmeLF1)
anova(lmeLF2)
####C13in HF
lmeHF1 <- lme(C13HF~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeHF2 <- lme(C13HF~ Type+Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeHF3 <- lme(C13HF~ Type, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit)
lmeHF4 <- lme(C13HF~ Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
AIC(lmeHF1,lmeHF2,lmeHF3,lmeHF4)
anova(lmeHF1)
anova(lmeHF2)
lmeHF0<-lmer(C13HF ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)
AIC(lmeHF1,lmeHF0)
####C13in Soil C
lmeC13Soil1 <- lme(C13Soil~ Type*Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeC13Soil2 <- lme(C13Soil~ Type+Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
lmeC13Soil3 <- lme(C13Soil~ Type, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit)
lmeC13Soil4 <- lme(C13Soil~ Depth, data =landuse,random = ~1|Replicate,method = "REML", na.action=na.omit) 
AIC(lmeC13Soil1,lmeC13Soil2,lmeC13Soil3,lmeC13Soil4)
anova(lmeC13Soil1)
#numDF denDF   F-value p-value
#(Intercept)     1    15 13037.019  <.0001
#Type            3     9    13.700  0.0011
#Depth           1    15     5.496  0.0332
#Type:Depth      3    15     2.358  0.1127
anova(lmeC13Soil2)
lmeC13Soil0<-lmer(C13HF ~ 1 + (1|Replicate), data = landuse,REML=T,na.action=na.omit)
AIC(lmeC13Soil1,lmeC13Soil0)

